/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models.baked;

import com.ferreusveritas.dynamictrees.block.leaves.PalmLeavesProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public abstract class PalmLeavesBakedModel
implements IDynamicBakedModel {
    protected RenderTypeGroup renderGroup = new RenderTypeGroup(RenderType.m_110463_(), RenderType.m_110463_());
    protected final BlockModel blockModel;
    TextureAtlasSprite frondsTexture;
    protected final BakedModel[] bakedFronds = new BakedModel[8];

    public PalmLeavesBakedModel(ResourceLocation frondsResLoc, Function<Material, TextureAtlasSprite> spriteGetter) {
        this.blockModel = new BlockModel(null, new ArrayList(), new HashMap(), Boolean.valueOf(false), BlockModel.GuiLight.FRONT, ItemTransforms.f_111786_, new ArrayList());
        this.frondsTexture = spriteGetter.apply(new Material(InventoryMenu.f_39692_, frondsResLoc));
        this.initModels();
    }

    public abstract void initModels();

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType renderType) {
        if (state == null || side != null) {
            return Collections.emptyList();
        }
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
        int direction = (Integer)state.m_61143_((Property)PalmLeavesProperties.DynamicPalmLeavesBlock.DIRECTION);
        if (direction != 0) {
            quads.addAll(this.bakedFronds[direction - 1].getQuads(state, null, rand, extraData, renderType));
        }
        return quads;
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return true;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.frondsTexture;
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110457_()});
    }

    public static class BlockVertexData {
        public float x;
        public float y;
        public float z;
        public int color;
        public float u;
        public float v;

        public BlockVertexData(float x, float y, float z, float u, float v) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.u = u;
            this.v = v;
            this.color = -1;
        }

        public BlockVertexData(BakedQuad quad, int vIndex) {
            this(quad.m_111303_(), vIndex);
        }

        public BlockVertexData(int[] data, int vIndex) {
            vIndex *= 8;
            this.x = Float.intBitsToFloat(data[vIndex++]);
            this.y = Float.intBitsToFloat(data[vIndex++]);
            this.z = Float.intBitsToFloat(data[vIndex++]);
            this.color = data[vIndex++];
            this.u = Float.intBitsToFloat(data[vIndex++]);
            this.v = Float.intBitsToFloat(data[vIndex]);
        }

        public int[] toInts() {
            return new int[]{Float.floatToRawIntBits(this.x), Float.floatToRawIntBits(this.y), Float.floatToRawIntBits(this.z), this.color, Float.floatToRawIntBits(this.u), Float.floatToRawIntBits(this.v), 0, 0};
        }

        protected int[] toInts(TextureAtlasSprite texture) {
            return new int[]{Float.floatToRawIntBits(this.x), Float.floatToRawIntBits(this.y), Float.floatToRawIntBits(this.z), this.color, Float.floatToRawIntBits(texture.m_118367_((double)this.u)), Float.floatToRawIntBits(texture.m_118393_((double)this.v)), 0, 0};
        }
    }
}

